package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.db.PersonTaskDAO;
import gov.va.vinci.dart.db.TaskDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestTask extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Assert.assertNull(Task.findById(0));
	}

	@Test
	public void testSix() throws Exception {
		
		Assert.assertNull(Task.findById(-1));
		
		List<Task> taskList = Task.listAll();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
		
		Task task = taskList.get(0);
		Assert.assertNotNull(task);
		Assert.assertTrue(task.getId() > 0);
		Assert.assertNotNull(task.getRequest());
		
		Task task2 = Task.findById(task.getId());
		Assert.assertNotNull(task2);
		Assert.assertEquals(task2, task);
	}

	@Test
	public void testSeven() throws Exception {
		
		List<Task> taskList = Task.listAll();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
	}

}
